*Association between covariates and social class / earnings

*Tim Goedemé, 26/04/2021


/*

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/


*/

*Globals

global place1 << data directory ... \2020-04\ >>
global place2 <<output 1 directory >>
global place3 <<output 2 directory >>
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IT LT LU LV MT NL NO PL PT RO RS SE SI UK


*Estimations
************
set matsize 5000, permanent

cap mat drop results1
cap mat drop results2
foreach ctry of global countries {
	di "`ctry'", _continue
	cap mat drop results	
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars2.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			replace sub = 0 if missers2!=0
			replace sub = 0 if earns1<=0 | earns2<=0
			
			/* cap drop class
			gen class=1 if esec08==1 | esec08==2
			replace class = 2 if esec08>2 & esec08<7
			replace class=3 if esec08>6 & esec08!=.
			
			lab define klassen 1 "Salariat" 2 "Intermediate" 3 "Working class"
			label values class klassen
			ta class */
			
			rename esec08 class
			
			/*if regexm("BG HU PL RO", "`ctry'")==1 global vars c.fyfte i.sex i.education i.health c.career c.nchilds c.nadults c.ndepadults
			else global vars c.fyfte i.sex i.immigrant i.education i.health c.career c.nchilds c.nadults c.ndepadults
			if "`ctry'"=="SI" global vars c.fyfte i.sex i.immigrant i.education i.health c.career c.nchilds c.nadults c.ndepadults
			*BG HU PL and RO: no immigrant variable due to too low prevalence; <<SI: education as continuous variable as low educated does not occur in high salariat not relevant here: back to categorical variable>> */
			
			global catvars sex immigrant education health
			global convars fyfte career nchilds nadults ndepadults
			
			*1. Social class and ...
			
			cap mat drop tempmat1
			foreach catvar of global catvars {
				*sum `catvar' if sub==1
				*replace `catvar' = r(max) if `catvar'>r(max) & `catvar'!=.
				svy, subpop(sub): tab class `catvar' 
				local val1 = e(p_Pear)
				mat def tempmat1 = nullmat(tempmat1) , `val1'
			}
			foreach convar of global convars {
				kwallis `convar' if sub==1, by(class)
				local val1 = chi2tail(r(df),r(chi2))
				mat def tempmat1 = nullmat(tempmat1) , `val1'
			}
			
			mat def results1 = nullmat(results1) \ tempmat1
			
			*2. Earnings and ...
			
			global catvars1 class ${catvars}
			cap mat drop tempmat1
			foreach catvar of global catvars1 {
				kwallis earns2 if sub==1, by(`catvar')
				local val1 = chi2tail(r(df),r(chi2))
				mat def tempmat1 = nullmat(tempmat1) , `val1'
			}
			foreach convar of global convars {
				spearman earns2 `convar' if sub==1 & class!=.
				local val1 = r(p)
				mat def tempmat1 = nullmat(tempmat1) , `val1'
			}
			mat def results2 = nullmat(results2) \ tempmat1
			
		}
	}
}
mat colnames results1  = ${catvars} ${convars}
mat colnames results2  = class ${catvars} ${convars}
mat rownames results1 = ${countries}
mat rownames results2 = ${countries}

mat li results1
mat li results2


